<?php

namespace app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Orders extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('quantity', 'total_amount');

    public function customer()
    {
        return $this->belongsTo('Customer', 'customer_id');
    }

    public function product()
    {
        return $this->belongsTo('Product', 'product_id');
    }

}